% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_urban_audit.R
\name{gisco_get_urban_audit}
\alias{gisco_get_urban_audit}
\title{Get GISCO greater cities and metropolitan areas \code{sf} polygons and points}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}
}
\usage{
gisco_get_urban_audit(
  year = "2020",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "RG",
  country = NULL,
  level = NULL
)
}
\arguments{
\item{year}{Release year of the file. One of "2001", "2004",
"2014", "2018" or "2020".}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
.geojson file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \strong{"LB"}: Labels - \code{POINT} object.
\item \strong{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
}}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Turkey","US","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{level}{Level of Urban Audit. Possible values are "CITIES", "FUA",
"GREATER_CITIES" or \code{NULL}, that would download the full dataset.}
}
\value{
A \code{sf} object specified by \code{spatialtype}.
}
\description{
Returns polygons and points corresponding to cities, greater cities and
metropolitan areas included on the
\href{https://ec.europa.eu/eurostat/web/regions-and-cities}{Urban Audit report}
of Eurostat.
}
\note{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
cities <- gisco_get_urban_audit(year = "2020", level = "CITIES")

if (!is.null(cities)) {
  bcn <- cities[cities$URAU_NAME == "Barcelona", ]

  library(ggplot2)
  ggplot(bcn) +
    geom_sf()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_communes]{gisco_get_communes()}}, \code{\link[=gisco_get_lau]{gisco_get_lau()}}

Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()}
}
\concept{political}
