% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_git_snapshot.R
\name{tar_git_snapshot_menu}
\alias{tar_git_snapshot_menu}
\title{Data snapshot menu (Git)}
\usage{
tar_git_snapshot_menu(
  commit,
  message,
  code,
  script,
  store,
  stash_gitignore,
  reporter,
  envir,
  callr_function,
  callr_arguments
)
}
\arguments{
\item{commit}{Character of length 1, Git SHA1 hash of the code commit
that will correspond to the data snapshot (if created).}

\item{message}{Optional Git commit message of the data snapshot.
If \code{NULL}, then the message is the Git commit message of the
matching code commit.}

\item{code}{Character of length 1, directory path to the code repository,
usually the root of the \code{targets} project.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[targets:tar_script]{tar_script()}},
\code{\link[targets:tar_config_get]{tar_config_get()}}, and \code{\link[targets:tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the data store of the pipeline.
If \code{NULL}, the \code{store} setting is left unchanged in the
YAML configuration file (default: \verb{_targets.yaml}).
Usually, the data store lives at \verb{_targets}.
Set \code{store} to a custom directory
to specify a path other than \verb{_targets/}. The path need not exist
before the pipeline begins, and it need not end with "_targets",
but it must be writeable.
For optimal performance, choose a storage location
with fast read/write access.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[targets:tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{stash_gitignore}{Logical of length 1, whether to temporarily
stash the \code{.gitignore} file of the data store. See the
"Stashing .gitignore" section for details.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[targets:tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
Integer of length 1: \code{2L} if the user agrees to snapshot,
\code{1L} if the user declines.
}
\description{
Check the project status and show an interactive menu
for \code{\link[=tar_git_snapshot]{tar_git_snapshot()}}.
}
\examples{
# See the examples of tar_git_snapshot().
}
\keyword{internal}
