% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glinvci.R
\name{glinv_gauss}
\alias{glinv_gauss}
\alias{lik.glinv_gauss}
\alias{grad.glinv_gauss}
\alias{hess.glinv_gauss}
\alias{print.glinv_gauss}
\title{Construct an object representing a GLInv model with respect to the underlying Gaussian process parameters.}
\usage{
glinv_gauss(tree, x0, dimtab = NULL, X = NULL)

\method{lik}{glinv_gauss}(mod, par = NULL, ...)

\method{grad}{glinv_gauss}(mod, par = NULL, lik = FALSE, ...)

\method{hess}{glinv_gauss}(mod, par = NULL, lik = FALSE, grad = FALSE, directions = NULL, ...)

\method{print}{glinv_gauss}(x, ...)
}
\arguments{
\item{tree}{A tree of class \code{ape::phylo}.}

\item{x0}{A vector representing the root's trait vector.}

\item{dimtab}{An integer, a vector of integers, or NULL, specifying the number of dimensions of each nodes of the tree.
If it is a vector, \code{dimtab[n]} is the trait vector dimension of node \code{n}. If it is only a single
integer than all nodes are assumed to have the same amount of dimensions. If it is NULL then all
nodes are asummed to have the same amount of dimensions as \code{x0}.}

\item{X}{Trait values, either a matrix in which \code{X[p,n]} stores the \eqn{p}-th dimension
of the multivariate trait of the \eqn{n}-th tip of the phylogeny, or a list in which
\code{X[[n]]} is a numeric vector representing the multivariate trait of the \eqn{n}-th tip.
The latter form is required if not all the tips has the same number of dimensions.}

\item{mod}{A model object of class \code{glinv_gauss}.}

\item{par}{A vector, containing the parameters at which the likelihood should be computed.}

\item{...}{Not used.}

\item{lik}{If \code{TRUE}, \code{grad.glinv_gauss} and \code{hess.glinv_gauss} returns also the log-likelihood.}

\item{grad}{If \code{TRUE}, \code{hess.glinv_gauss} returns also the gradient.}

\item{directions}{Either \code{NULL} or a matrix with \code{mod$nparams} many rows and arbitrarily many columns.
If \code{NULL}, `hess.glinv_gauss` returns the Hessian matrix itself, which is typically
a huge matrix; otherwise, the funciton returns a square matrix \eqn{M} such that \eqn{M_ij}
contains \eqn{d_i^T H d_j}, where \eqn{d_i} is the \eqn{i}-th column of \code{directions} and
\eqn{H} is the huge Hessian matrix, without storing \eqn{H} itself in memory.}

\item{x}{An object of class \code{glinv_gauss}.}
}
\value{
An object of S3 class \code{glinv_gauss} with the following components
              \describe{
                \item{ctree}{A pointer to an internal C structure.}
                \item{apetree}{Identical to the \code{tree} argument.}
                \item{x0}{The trait vector at the root of the tree.}
                \item{dimtab}{Identical to the \code{dimtab} argument.}
                \item{gaussdim}{The number of dimension of the parameter space of this model.}
              }
}
\description{
The \code{glinv_gauss} function constructs an object of class \code{glinv_gauss}, which represents a lower-level 
GLInv model with respect to the underlying Gaussian process space. The likelihood Hessian of, for example, Brownian motion
and Ornstein-Uhlenbeck models can be computed by applying the calculus chain rule to the output of Jacobians and Hessians
from this class.

The \code{lik.glinv_gauss} function computes the likelihood of a full \code{glinv_gauss} model.

The \code{grad.glinv_gauss} function computes the log-likelihood gradients of a \code{glinv_gauss} models.
If \code{par} is NULL, it returns a function that, when called, returns the same thing as if \code{grad.glinv_gauss}
were called with \code{par} argument.

The \code{hess.glinv_gauss} function computes the log-likelihood Hessian of a \code{glinv_gauss} models.
}
\details{
The \code{glinv_gauss} class does not include any information for dealing with evolutionary regimes, lost traits, and
missing data, nor does it facilitate reparametrisation. These are all functionality of the \code{glinv} class instead.
The member variables of the objects of the \code{glinv_gauss} class only are for the users' convenience to \emph{read}
the information about the model, and the user \emph{should not} modify its member variables directly.

For each non-root node \eqn{i} in the phylogeny, the multivariate trait vector \eqn{x_i} follows
a Gaussian distribution with mean \eqn{\Phi_i x_j + w_i} and variance \eqn{V_i} when conditioned on
the mother's trait vector \eqn{x_j}. The `parameters' of this model is, therefore, the joint of all
\eqn{(\Phi_i, w_i V'_i)} for all nodes \eqn{i}. The root does not have any associated parameters.

The parameter vector \code{par} should be the concatenation of all \eqn{(\Phi_i, w_i, V'_i)} in accending
order sorted by \eqn{i}, the node number (which is the same node numbers as in \code{tree$edge}). The matrix
\eqn{\Phi_i} is flattened in column-major order and \eqn{V'_i} is the lower-triangular part of V_i,
column-major-flattened. Since the root does not have parameters, its entry is simply skipped.
For example, if a binary tree has 10 non-root nodes in total and each of them are 3 dimensional, then
each \eqn{(\Phi_i, w_i, V'_i)} should have \eqn{9+3+6=18} elements; thus after concatenation \code{par} should
be a 180 elements.
}
\examples{
tr = ape::rtree(3)
model = glinv_gauss(tr, x0=c(0,0), X=matrix(rnorm(6),2,3))
par = unlist(
 list(
   list('Phi' = c(1,0,0,1), # Parameters for node #1, a tip
        'w'   = c(-1,1),
        'V'   = c(1,0,1)),  # Lower triangular part of a 2D identity matrix
   list('Phi' = c(2,0,0,2), # For node #2, a tip
        'w'   = c(-2,2),
        'V'   = c(2,0,2)),
   list('Phi' = c(3,0,0,3), # For node #3, a tip
        'w'   = c(-3,3),
        'V'   = c(3,0,3)),
   list('Phi' = c(4,0,0,4), # For node #5. Node #4 skipped as it is the root
        'w'   = c(-4,4),
        'V'   = c(4,0,4))
   ))
print(par)
lik(model, par)
grad(model, par)
hess(model, par)
}
\references{
Mitov V, Bartoszek K, Asimomitis G, Stadler T (2019). “Fast likelihood calculation for multivariate Gaussian phylogenetic models with shifts.” Theor. Popul. Biol.. https://doi.org/10.1016/j.tpb.2019.11.005.
}
