% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcml_la}
\alias{mcml_la}
\title{Maximum Likelihood with Laplace Approximation and Derivative Free Optimisation}
\usage{
mcml_la(
  cov,
  data,
  eff_range,
  Z,
  X,
  y,
  family,
  link,
  start,
  usehess = FALSE,
  tol = 0.001,
  verbose = TRUE,
  trace = 0L,
  maxiter = 10L
)
}
\arguments{
\item{cov}{An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.}

\item{data}{Vector of data. Created by flattening the matrices in column-major order of the data used in each block.}

\item{eff_range}{Vector of values with the effective range parameters of the covariance functions, where required.}

\item{Z}{Matrix Z of the GLMM}

\item{X}{Matrix X of the GLMM}

\item{y}{Vector of observations}

\item{family}{Character specifying the family}

\item{link}{Character specifying the link function}

\item{start}{Vector of starting values for the optimisation}

\item{usehess}{Logical inticating whether to estimate the standard errors from the Hessian matrix}

\item{tol}{Value of the tolerance. The algorithm termninates if differences in values of parameters between
iterations are all less than this value.}

\item{verbose}{Logical indicating whether to provide output to the console}

\item{trace}{Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output}

\item{maxiter}{Integer. Maximum number of algorithm iterations before exiting.}
}
\value{
A list with estimates of model parameters, standard errors, and random effects
}
\description{
Maximum Likelihood with Laplace Approximation and Derivative Free Optimisation. These
functions are not intended to be used by the normal user who can access this functionality 
with the member functions of the \link[glmmrMCML]{ModelMCML} class.
}
\examples{
\donttest{
## small example with simulated data
## create data and model object with 
## parameters to simulate data and 
## act as starting values
df <- nelder(~(j(10) * t(3)) > i(5))
des <- ModelMCML$new(
 covariance = list(
  formula =  ~(1|gr(j)*ar1(t)),
  parameters = c(0.25,0.7)
),
mean = list(
  formula = ~factor(t)-1,
  parameters = rnorm(3)
),
data=df,
family=gaussian()
)
## simulate data
y <- des$sim_data()
## get covariance definition matrix
ddata <- des$covariance$get_D_data()
out3 <- mcml_la(cov=ddata$cov,
   data=ddata$data,
   eff_range = rep(0,30),
   Z = as.matrix(des$covariance$Z),
   X = as.matrix(des$mean_function$X),
   y = y,
   family = des$mean_function$family[[1]],
   link=des$mean_function$family[[2]],
   start = c(rep(0.01,5),0.25,0.7,1.0),
   usehess = FALSE,
   tol=1e-2,verbose=FALSE,trace=0)
   }
}
