% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived.traits.R
\name{iudt.translate}
\alias{iudt.translate}
\title{Translate names between computer readable and human readable
for derived traits of IgG with UPLC}
\usage{
iudt.translate(orignames, to = "inverse", method = "2014")
}
\arguments{
\item{orignames}{vector; type string}

\item{to}{type of translation. If \code{inverse} is used everything will be
translated. For \code{computer} names will be translated to computer
readable, and for \code{human} names will be translated to human readable.}

\item{method}{year of the derived traits definition. By default 2014.}
}
\value{
Returns a character vector with original and translated names
}
\description{
Translates names between computer readable and human readable
for derived traits of IgG with UPLC
}
\details{
User can choose which definition of the derived traits he will use
(see references for different versions/definitions of derived traits).
}
\author{
Ivo Ugrina
}
\references{
Jennifer E. Huffman et al. (2014)
"Comparative Performance of Four Methods for High-throughput Glycosylation Analysis of Immunoglobulin G in Genetic and Epidemiological Research*"
\url{http://dx.doi.org/10.1074/mcp.M113.037465}
}

