% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkage.R
\name{has_linkages}
\alias{has_linkages}
\title{Determine if a Glycan Structure has Linkages}
\usage{
has_linkages(glycan)
}
\arguments{
\item{glycan}{A glyrepr_structure vector.}
}
\value{
A logical vector indicating if each glycan structure has linkages.
}
\description{
Unknown linkages in a glycan structure are represented by "??-?".
This function checks if all linkages in a glycan structure are unknown.
Note that even only one linkage is partial known (e.g. "a?-?"),
this function will return \code{TRUE}.
}
\examples{
glycan <- o_glycan_core_1(linkage = TRUE)
has_linkages(glycan)
print(glycan)

glycan <- remove_linkages(glycan)
has_linkages(glycan)
print(glycan)

}
\seealso{
\code{\link[=remove_linkages]{remove_linkages()}}, \code{\link[=possible_linkages]{possible_linkages()}}
}
