% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line.R
\name{Line}
\alias{Line}
\title{Create \code{Line} Object}
\usage{
Line(
  pitches,
  durations,
  tie = NULL,
  name = NULL,
  as = NULL,
  to = NULL,
  after = NULL,
  bar = NULL,
  offset = NULL
)
}
\arguments{
\item{pitches}{A list whose members are
\enumerate{
\item single pitch notations, like "C4", to represent the pitch contents of
notes,
\item single MIDI note numbers, like 60 or "60", also to represent the pitch
contents of notes,
\item single \code{NA}s to represent the pitch contents of rests, or
\item vectors of pitch notations and MIDI note numbers, like \code{c("C4", "61")},
to represent the pitch contents of chords.
}}

\item{durations}{A list whose members are
\enumerate{
\item single duration notations or their abbreviations, like "quarter" or
just "q",
\item single duration values, like 1, which is equivalent to "quarter", or
\item \code{Duration} objects returned by \code{tuplet()}, which is used to create
complex tuplets.
}}

\item{tie}{Optional. A list of indices of argument \code{pitches}, which
indicates at which positions to add ties.}

\item{name}{Optional. A single character to name the \code{Line} object.}

\item{as}{Optional. "part", "staff" or "voice", to specify the state
of the \code{Line} object. The default value is "part".}

\item{to}{Optional. An index or a \code{Line} name, which indicates with which
\code{Line} object as the reference to add the \code{Line} object.}

\item{after}{Optional. A single logical which indicates whether to add the
\code{Line} object after or before a reference \code{Line} object. The default value
is \code{TRUE}.}

\item{bar}{Optional. A positive integer which indicates the number of
the measure to which to insert the \code{Line} object. By default, a \code{Line}
object will be inserted to the first measure.}

\item{offset}{Optional. A duration value, sum of duration values or 0,
which indicates the position in a measure, at which to insert the \code{Line}
object. The default value is 0.}
}
\value{
A list with class \code{Line}.
}
\description{
Create a \code{Line} object.

\code{Line} objects represent musical lines.
}
\examples{
# create a Music object
m <- Music() + Meter(4, 4) + Line(list("C4"), list(8), name = "a")

# create a Line object
l <- Line(
  pitches = list("C5", "C5", "C5"),
  durations = list(1, 1, 1),

  # tie the first two notes
  tie = list(1),

  # add the Line as a voice
  as = "voice",

  # with Line "a" as reference
  to = "a",

  # before Line "a"
  after = FALSE,

  # insert the Line to bar 2 with offset 1
  bar = 2,
  offset = 1
)
l

# add the Line object to the Music object
m <- m + l
m

if (interactive()) {
  show(m)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding \code{Line} objects to a \code{Music} object.

\code{vignette("gm", package = "gm")} for more details about \code{Line} objects.
}
