% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{getStackElement}
\alias{getStackElement}
\alias{setStackElement}
\alias{getStackElement.default}
\alias{getStackElement.list}
\alias{getStackElement.DataFrameStack}
\alias{setStackElement.default}
\alias{setStackElement.data.frame}
\alias{setStackElement.list}
\alias{setStackElement.DataFrameStack}
\title{Set or get the i-th data frame of a data.frame stack}
\usage{
getStackElement(x, i, ...)

\method{getStackElement}{default}(x, i, ...)

\method{getStackElement}{list}(x, i, ...)

\method{getStackElement}{DataFrameStack}(x, i, MARGIN = stackDim(x), ...)

\method{setStackElement}{default}(x, i, value, ...)

\method{setStackElement}{data.frame}(x, i, value, ...)

\method{setStackElement}{list}(x, i, value, ...)

\method{setStackElement}{DataFrameStack}(x, i, value, MARGIN = stackDim(x), ...)
}
\arguments{
\item{x}{container data, typically a \code{\link[=DataFrameStack]{DataFrameStack()}}, but it can also be certain \code{\link[sp:Spatial]{sp::Spatial()}}
object derivates of it}

\item{i}{index (or name) of the element of the stack to extract or replace}

\item{...}{extra arguments for generic functionality}

\item{MARGIN}{which dimension is the stacking dimension? you seldom want to touch this!!}

\item{value}{for the setting operation, the new data.frame to replace the selected one; note
that the compatibility of the dimensions of \code{value} is only checked for setStackElement.DataFrameStack
and its Spatial derivates; for other methods \code{setStackElement} can break the consistency of the
stack!}
}
\value{
For the getters, the result is the data.frame of the stack asked for. For the setters
the result is the original DataFrameStack with the corresponding element replaced. Spatial methods
return the corresponding spatial object, ie. the spatial information of the stack is transferred to the
extracted element.
}
\description{
Set or get one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Set or get one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}

\item \code{list}: Set or get one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}

\item \code{DataFrameStack}: Set or get one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}

\item \code{default}: Set or get one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}

\item \code{data.frame}: Set  one element of the \code{\link[=DataFrameStack]{DataFrameStack()}} in data.frame form

\item \code{list}: Set get one element of a \code{\link[=DataFrameStack]{DataFrameStack()}} in list form

\item \code{DataFrameStack}: Set one element of the \code{\link[=DataFrameStack]{DataFrameStack()}}
}}

\examples{
ar = array(1:30, dim = c(5,2,3), dimnames=list(obs=1:5, vars=c("A","B"), rep=1:3))
dfs = DataFrameStack(ar, stackDim="rep")
dfs
stackDim(dfs)
getStackElement(dfs, 1)
}
