% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R
\name{as.gstatVariogram}
\alias{as.gstatVariogram}
\alias{as.gstatVariogram.default}
\alias{as.gstatVariogram.gmEVario}
\alias{as.gstatVariogram.logratioVariogram}
\alias{as.gstatVariogram.logratioVariogramAnisotropy}
\title{Represent an empirical variogram in "gstatVariogram" format}
\usage{
as.gstatVariogram(vgemp, ...)

\method{as.gstatVariogram}{default}(vgemp, ...)

\method{as.gstatVariogram}{gmEVario}(vgemp, ...)

\method{as.gstatVariogram}{logratioVariogram}(
  vgemp,
  V = NULL,
  dir.hor = 0,
  dir.ver = 0,
  prefix = NULL,
  ...
)

\method{as.gstatVariogram}{logratioVariogramAnisotropy}(vgemp, V = NULL, ...)
}
\arguments{
\item{vgemp}{empirical variogram of any kind}

\item{...}{further parameters (for generic functionality)}

\item{V}{eventually, indicator of which logratio should be used (one of: a matrix of logcontrasts, or of the strings "ilr", "alr" or "clr")}

\item{dir.hor}{eventually, which horizontal direction is captured by the  variogram provided (seldom to be touched!)}

\item{dir.ver}{eventually, which vertical direction is captured by the  variogram provided (seldom to be touched!)}

\item{prefix}{prefix name to use for the variables created (seldom needed)}
}
\value{
The function returns an object of class "gstatVariogram" containing the empirical variogram provided.
See \code{gstat::variogram()} for details.
}
\description{
Represent an empirical variogram in "gstatVariogram" format, from package "gstat"; see \code{\link[gstat:variogram]{gstat::variogram()}}
for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Represent an empirical variogram in "gstatVariogram" format

\item \code{gmEVario}: Represent an empirical variogram in "gstatVariogram" format

\item \code{logratioVariogram}: Represent an empirical variogram in "gstatVariogram" format

\item \code{logratioVariogramAnisotropy}: Represent an empirical variogram in "gstatVariogram" format
}}

\examples{
data("jura", package = "gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:13])
lrvg = gmGeostats::logratioVariogram(data=Zc, loc=X)
as.gstatVariogram(lrvg, V="alr")
}
