% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R
\name{LR_test}
\alias{LR_test}
\title{Perform likelihood ratio test for a GMVAR, StMVAR, or G-StMVAR model}
\usage{
LR_test(gsmvar1, gsmvar2)
}
\arguments{
\item{gsmvar1}{an object of class \code{'gsmvar'} generated by \code{fitGSMVAR} or \code{GSMVAR}, containing
the \strong{freely estimated} model.}

\item{gsmvar2}{an object of class \code{'gsmvar'} generated by \code{fitGSMVAR} or \code{GSMVAR}, containing
the \strong{constrained} model.}
}
\value{
A list with class "htest" containing the following components:
  \item{statistic}{the value of the likelihood ratio statistics.}
  \item{parameter}{the degrees of freedom of the likelihood ratio statistic.}
  \item{p.value}{the p-value of the test.}
  \item{alternative}{a character string describing the alternative hypothesis.}
  \item{method}{a character string indicating the type of the test (likelihood ratio test).}
  \item{data.name}{a character string giving the names of the supplied models, gsmar1 and gsmar2.}
  \item{gsmvar1}{the supplied argument gsmvar1}
  \item{gsmvar2}{the supplied argument gsmvar2}
}
\description{
\code{LR_test} performs a likelihood ratio test for a GMVAR, StMVAR, or G-StMVAR model
}
\details{
Performs a likelihood ratio test, testing the null hypothesis that the true parameter value lies
  in the constrained parameter space. Under the null, the test statistic is asymptotically
  \eqn{\chi^2}-distributed with \eqn{k} degrees of freedom, \eqn{k} being the difference in the dimensions
  of the unconstrained and constrained parameter spaces.

  Note that this function does \strong{not} verify that the two models are actually nested.
}
\examples{
\donttest{
 ## These are long running examples that use parallel computing!
 ## The below examples take around 1 minute to run.

 # Structural GMVAR(2, 2), d=2 model with recursive identification
 W22 <- matrix(c(1, NA, 0, 1), nrow=2, byrow=FALSE)
 fit22s <- fitGSMVAR(gdpdef, p=2, M=2, structural_pars=list(W=W22),
                    ncalls=1, seeds=2)

 # The same model but the AR coefficients restricted to be the same
 # in both regimes:
 C_mat <- rbind(diag(2*2^2), diag(2*2^2))
 fit22sc <- fitGSMVAR(gdpdef, p=2, M=2, constraints=C_mat,
                     structural_pars=list(W=W22), ncalls=1, seeds=1)

 # Test the AR constraints with likelihood ratio test:
 LR_test(fit22s, fit22sc)
 }
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2021. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
   \item Virolainen S. 2021. Gaussian and Student's t mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
\seealso{
\code{\link{Wald_test}}, \code{\link{fitGSMVAR}}, \code{\link{GSMVAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
