% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalDifferentiation.R
\name{calc_gradient}
\alias{calc_gradient}
\alias{calc_hessian}
\alias{get_gradient}
\alias{get_hessian}
\alias{get_foc}
\alias{get_soc}
\title{Calculate gradient or Hessian matrix}
\usage{
calc_gradient(x, fn, h = 6e-06, varying_h = NULL, ...)

calc_hessian(x, fn, h = 6e-06, varying_h = NULL, ...)

get_gradient(gsmvar, custom_h = NULL)

get_hessian(gsmvar, custom_h = NULL)

get_foc(gsmvar, custom_h = NULL)

get_soc(gsmvar, custom_h = NULL)
}
\arguments{
\item{x}{a numeric vector specifying the point where the gradient or Hessian should be calculated.}

\item{fn}{a function that takes in argument \code{x} as the \strong{first} argument.}

\item{h}{difference used to approximate the derivatives.}

\item{varying_h}{a numeric vector with the same length as \code{x} specifying the difference \code{h}
for each dimension separately. If \code{NULL} (default), then the difference given as parameter \code{h}
will be used for all dimensions.}

\item{...}{other arguments passed to \code{fn}}

\item{gsmvar}{an object of class \code{'gsmvar'}, typically created with \code{fitGSMVAR} or \code{GSMVAR}.}

\item{custom_h}{same as \code{varying_h} but if \code{NULL} (default), then the difference \code{h} used
for differentiating overly large degrees of freedom parameters is adjusted to avoid numerical problems,
and the difference is \code{6e-6} for the other parameters.}
}
\value{
Gradient functions return numerical approximation of the gradient and Hessian functions return
  numerical approximation of the Hessian. \code{get_soc} returns eigenvalues of the Hessian matrix.
}
\description{
\code{calc_gradient} or \code{calc_hessian} calculates the gradient or Hessian matrix
  of the given function at the given point using central difference numerical approximation.
  \code{get_gradient} or \code{get_hessian} calculates the gradient or Hessian matrix of the
  log-likelihood function at the parameter estimates of a class \code{'gsmvar'} object. \code{get_soc}
  returns eigenvalues of the Hessian matrix, and \code{get_foc} is the same as \code{get_gradient}
  but named conveniently.
}
\details{
In particular, the functions \code{get_foc} and \code{get_soc} can be used to check whether
  the found estimates denote a (local) maximum point, a saddle point, or something else. Note that
  profile log-likelihood functions can be conveniently plotted with the function \code{profile_logliks}.
}
\section{Warning}{

  No argument checks!
}

\examples{
  # Simple function
  foo <- function(x) x^2 + x
  calc_gradient(x=1, fn=foo)
  calc_gradient(x=-0.5, fn=foo)

  # More complicated function
  foo <- function(x, a, b) a*x[1]^2 - b*x[2]^2
  calc_gradient(x=c(1, 2), fn=foo, a=0.3, b=0.1)

  \donttest{
  # GMVAR(1,2), d=2 model:
  params12 <- c(0.55, 0.112, 0.344, 0.055, -0.009, 0.718, 0.319, 0.005,
   0.03, 0.619, 0.173, 0.255, 0.017, -0.136, 0.858, 1.185, -0.012,
   0.136, 0.674)
  mod12 <- GSMVAR(gdpdef, p=1, M=2, params=params12)
  get_gradient(mod12)
  get_hessian(mod12)
  get_soc(mod12)
  }
}
\seealso{
\code{\link{profile_logliks}}
}
