% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_2nd_dr}
\alias{deriv_2nd_dr}
\title{Analytic second derivative matrix for drift process}
\usage{
deriv_2nd_dr(tau)
}
\arguments{
\item{tau}{A \code{vec} that contains the scales to be processed (e.g. 2^(1:J))}
}
\value{
A \code{matrix} with the first column containing the second partial derivative with respect to \eqn{\omega _0}{omega[0]}.
}
\description{
Analytic second derivative matrix for drift process
}
\details{
The haar wavelet variance is given as \eqn{{\nu ^2}\left( \tau  \right) = \frac{{{\tau ^2}\omega _0^2}}{2}}{nu^2(tau) = tau^2 omega_0^2 / 2}.
Taking the derivative with respect to \eqn{\omega _0^2}{omega_0^2} yields: \eqn{\frac{\partial }{{\partial {\omega _0}}}{\nu ^2}\left( \tau  \right) = {\tau ^2}{\omega _0}}{tau^2 * omega_0}
Taking second derivative with respect to \eqn{\omega _0^2}{omega_0^2} yields: \eqn{\frac{{{\partial ^2}}}{{\partial \omega _0^2}}{\nu ^2}\left( \tau  \right) = {\tau ^2}}{tau^2}
}
\examples{
deriv_2nd_dr(2^(1:5))
}
\author{
JJB
}

