% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.R
\name{wvar.imu}
\alias{wvar.imu}
\title{Wavelet Variance for IMU Object}
\usage{
\method{wvar}{imu}(x, alpha = 0.05, robust = F, eff = 0.6)
}
\arguments{
\item{x}{An \code{imu} object.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level.}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}
}
\value{
A \code{wvar.imu} object which can be plotted directly.
}
\description{
Generates the Wavelet Variance for IMU Object.
}
\examples{
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)
test = imu(imu6, gyroscope = 1:3, accelerometer = 4:6)
df = wvar.imu(test)
}
}

