% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarGS_assoc.R
\name{Var.assoc}
\alias{Var.assoc}
\title{Uncertanty association}
\usage{
Var.assoc(qt, m_score, v_score, iter = 50)
}
\arguments{
\item{qt}{A numeric vector.}

\item{m_score}{A numeric vector}

\item{v_score}{A numeric vector with positive values}

\item{iter}{A number of iterations for the Gauss-Newton algorithm}
}
\value{
A list with the values:

* a, the association between v_score and the actual variance.
* pval, the p-value of the likelihood ratio test
}
\description{
This function finds the association between the predicted uncertanty of some estimates of a trait to the "actual uncertanty" of the estimates.
Suppose we have estimates of some trait (this might be a polygenic risk score).
Moreover, suppose we have assigned a variance value to each estimate (this might be a variance risk score) to reflect
how certain we believe we are about each estimate. Given the true trait values, this function evaluates how well the assigned
variance values reflect reality.

We use a likelihood ratio test with 1 degree of freedom
* H0: y~N(mu+b*m_score,sigma_sq),
* H1: y~N(mu+b*m_score,sigma_sq*(v_score)^a),
where y is the trait m_score is the estimate of the trait and v_score is the variance assigned to the estimate.
Thus H0 has three degrees of freedom (mu,b,sigma_sq), whereas H1 has four (mu,b,sigma_sq,a)
}
\examples{

n_val <- 50000L
trait_vec <- rnorm(n_val,0,1)
var_vec <- exp(rnorm(n_val,0,0.1))
est_vec <- trait_vec+rnorm(n_val,0,var_vec)
res <- Var.assoc(trait_vec,est_vec,var_vec, iter = 20)
}
