% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{cr_buildtrigger_make}
\alias{cr_buildtrigger_make}
\title{Create a buildtrigger object}
\usage{
cr_buildtrigger_make(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=cr_buildtrigger]{cr_buildtrigger}}
  \describe{
    \item{\code{trigger}}{The trigger source which will be a \link{RepoSource} or a \link{GitHubEventsConfig}}
    \item{\code{build}}{A file location within the trigger source to use for the build steps, or a \link{Build} object}
    \item{\code{projectId}}{ID of the project for which to configure automatic builds}
    \item{\code{name}}{User assigned name of the trigger}
    \item{\code{description}}{Human-readable description of this trigger}
    \item{\code{tags}}{Tags for annotation of a `BuildTrigger`}
    \item{\code{disabled}}{If true, the trigger will never result in a build}
    \item{\code{substitutions}}{A named list of Build macro variables}
    \item{\code{ignoredFiles}}{ignored_files and included_files are file glob matches extended with support for "**".}
    \item{\code{includedFiles}}{If any of the files altered in the commit pass the ignored_files}
  }}
}
\description{
Create a buildtrigger object
}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
