% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{cr_deploy_pkgdown}
\alias{cr_deploy_pkgdown}
\title{Deploy a cloudbuild.yml for a pkgdown website of an R package}
\usage{
cr_deploy_pkgdown(
  steps = NULL,
  secret,
  github_repo = "$_GITHUB_REPO",
  cloudbuild_file = "cloudbuild-pkgdown.yml",
  git_email = "googlecloudrunner@r.com",
  env = NULL,
  build_image = "gcr.io/gcer-public/packagetools:master",
  post_setup = NULL,
  post_clone = NULL
)
}
\arguments{
\item{steps}{extra steps to run before the pkgdown website steps run}

\item{secret}{The name of the secret on Google Secret Manager for the git ssh private key}

\item{github_repo}{The GitHub repo to deploy pkgdown website from and to.}

\item{cloudbuild_file}{The cloudbuild yaml file to write to}

\item{git_email}{The email the git commands will be identifying as}

\item{env}{A character vector of env arguments to set for all steps}

\item{build_image}{A docker image with \code{pkgdown} installed}

\item{post_setup}{Steps that occur after git setup}

\item{post_clone}{A \link{cr_buildstep} that occurs after the repo is cloned}
}
\description{
This builds a pkgdown website each time the trigger fires and deploys it to git
}
\details{
The trigger repository needs to hold an R package configured to build a pkgdown website.

For GitHub, the repository will also need to be linked to the project you are building within, via \url{https://console.cloud.google.com/cloud-build/triggers/connect}

The git ssh keys need to be deployed to Google KMS for the deployment of the website - see \link{cr_buildstep_git} - this only needs to be done once per Git account.  You then need to commit the encrypted ssh key (by default called \code{id_rsa.enc})
}
\examples{

pd <- cr_deploy_pkgdown(secret = "my_git_secret")
pd
file.exists("cloudbuild-pkgdown.yml")
unlink("cloudbuild-pkgdown.yml")

}
\seealso{
Create your own custom deployment using \link{cr_buildstep_pkgdown} which this function uses with some defaults.

Other Deployment functions: 
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_git_html}()},
\code{\link{cr_deploy_github_docker}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
