% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buckets.R
\name{gcs_list_buckets}
\alias{gcs_list_buckets}
\title{List buckets}
\usage{
gcs_list_buckets(projectId, prefix = "", projection = c("noAcl",
  "full"), maxResults = 1000, detail = c("summary", "full"))
}
\arguments{
\item{projectId}{Project containing buckets to list}

\item{prefix}{Filter results to names beginning with this prefix}

\item{projection}{Properties to return. Default noAcl omits acl properties}

\item{maxResults}{Max number of results}

\item{detail}{Set level of detail}
}
\value{
\code{data.frame} of buckets
}
\description{
List the buckets your projectId has access to
}
\details{
Columns returned by \code{detail} are:

\itemize{
  \item \code{summary} - name, storageClass, location ,updated
  \item \code{full} - as above plus: id, selfLink, projectNumber, timeCreated, metageneration, etag
 }
}
\examples{

\dontrun{

buckets <- gcs_list_buckets("your-project")

## use the name of the bucket to get more meta data
bucket_meta <- gcs_get_bucket(buckets$name[[1]])

}

}
\seealso{
Other bucket functions: \code{\link{gcs_create_bucket}},
  \code{\link{gcs_create_lifecycle}},
  \code{\link{gcs_delete_bucket}},
  \code{\link{gcs_get_bucket}},
  \code{\link{gcs_get_global_bucket}},
  \code{\link{gcs_global_bucket}}
}
\concept{bucket functions}
