% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{gce_ssh}
\alias{gce_ssh}
\alias{gce_ssh_download}
\alias{gce_ssh_upload}
\title{Remotely execute ssh code, upload & download files.}
\usage{
gce_ssh(instance, ..., key.pub = NULL, key.private = NULL, wait = TRUE,
  capture_text = FALSE, username = Sys.info()[["user"]])

gce_ssh_upload(instance, local, remote, username = Sys.info()[["user"]],
  key.pub = NULL, key.private = NULL, verbose = FALSE, wait = TRUE)

gce_ssh_download(instance, remote, local, username = Sys.info()[["user"]],
  key.pub = NULL, key.private = NULL, verbose = FALSE,
  overwrite = FALSE, wait = TRUE)
}
\arguments{
\item{instance}{Name of the instance of run ssh command upon}

\item{...}{Shell commands to run. Multiple commands are combined with
\code{&&} so that execution will halt after the first failure.}

\item{key.pub}{The filepath location of the public key, only needed first call per session}

\item{key.private}{The filepath location of the private key, only needed first call per session}

\item{wait}{Whether then SSH output should be waited for or run it asynchronously.}

\item{capture_text}{whether to return the output of the SSH command into an R text}

\item{username}{The username you used to generate the key-pair}

\item{local, remote}{Local and remote paths.}

\item{verbose}{If TRUE, will print command before executing it.}

\item{overwrite}{If TRUE, will overwrite the local file if exists.}
}
\value{
If capture_text is TRUE, the text of the SSH command result.
}
\description{
Assumes that you have ssh & scp installed.
}
\details{
Only works connecting to linux based instances.

On Windows you will need to install an ssh command line client.

You will need to generate a new SSH key-pair if you have not connected to the instance before.

Otherwise, instructions for this can be found here: \url{https://cloud.google.com/compute/docs/instances/connecting-to-instance}.

When you have generated it run \link{gce_ssh_setup} once to initiate setup.

Uploads and downloads are recursive, so if you specify a directory,
everything inside the directory will also be downloaded.
}
\examples{

\dontrun{

  gce_ssh("rbase", "sudo journalctl -u rstudio")

}

}
\seealso{
\url{https://cloud.google.com/compute/docs/instances/connecting-to-instance}

Other ssh functions: \code{\link{gce_ssh_browser}},
  \code{\link{gce_ssh_setup}}
}

