% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_token}
\alias{drive_token}
\title{Produce Google token}
\usage{
drive_token(verbose = FALSE)
}
\arguments{
\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
a \code{request} object (an S3 class provided by \link[httr:httr]{httr})
}
\description{
For internal use or for those programming around the Drive API. Produces a
token prepared for use with \code{\link[=generate_request]{generate_request()}} and \code{\link[=build_request]{build_request()}}. Most
users do not need to handle tokens "by hand" or, even if they need some
control, \code{\link[=drive_auth]{drive_auth()}} is what they need. If there is no current token,
\code{\link[=drive_auth]{drive_auth()}} is called to either load from cache or initiate OAuth2.0 flow.
If auth has been deactivated via \code{\link[=drive_auth_config]{drive_auth_config()}}, \code{drive_token()}
returns \code{NULL}.
}
\examples{
\dontrun{
req <- generate_request(
  "drive.files.get",
  list(fileId = "abc"),
  token = drive_token()
)
req
}
}
\seealso{
Other low-level API functions: \code{\link{generate_request}},
  \code{\link{make_request}},
  \code{\link{process_response}}
}
