% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_rename.R
\name{drive_rename}
\alias{drive_rename}
\title{Rename a Drive file}
\usage{
drive_rename(file, name = NULL, verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{name}{Character. Name you would like the file to have.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
This is a wrapper for \code{\link[=drive_mv]{drive_mv()}} that only renames a file.
If you would like to rename AND move the file, see \code{\link[=drive_mv]{drive_mv()}}.
}
\examples{
\dontrun{
## Create a folder to rename
folder <- drive_mkdir("folder-to-rename")

## Rename folder
folder <- folder \%>\%
  drive_rename(name = "renamed-folder")

## Clean up
drive_rm(folder)
}
}
