% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_reveal.R
\name{drive_reveal}
\alias{drive_reveal}
\title{Add column(s) with new information}
\usage{
drive_reveal(file, what = c("path", "trashed", "mime_type",
  "permissions", "published"))
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}.}

\item{what}{Character, describing the type of info you want to add:
\itemize{
\item path. Warning: this can be slow, especially if called on many files.
\item trashed
\item mime_type
\item permissions. Who is this file shared with and in which roles?
\item published
}}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
\code{drive_reveal()} adds extra information about your Drive files that is not
automatically present in the default \code{\link{dribble}} produced by googledrive. Why
is this info not always present?
\enumerate{
\item You don't always care about it.
\item It may require calling different endpoints in the Drive API. Example:
determining if a file has been "published on the web".
\item It might require additional API calls. Example: figuring out the path(s)
associated with a specific file.
}
}
\section{Special considerations for paths}{

Note that Google Drive does NOT behave like your local file system:
\itemize{
\item File and folder names need not be unique, even at a given level of
the hierarchy. A single name or file path can be associated with multiple
files (or zero or exactly one).
\item A file can have more than one direct parent. This implies that a
single file can be represented by multiple paths.
}

Bottom line: Do not assume there is a one-to-one relationship between file
name or path and a Drive file or folder. This implies the length of the input
(i.e. the number of input paths or the number of rows in a dribble) will not
necessarily equal the number rows in the output.
}

\section{Trashed}{

When \code{what = "trashed"}, the \code{\link{dribble}} gains a logical variable that
indicates whether a file is in the trash.
}

\section{MIME type}{
 When \code{what = "mime_type"}, the \code{\link{dribble}} gains a
variable of MIME types.
}

\section{Permissions}{

When \code{what = "permissions"} the \code{\link{dribble}} gains a logical variable \code{shared}
that indicates whether a file is shared and a new list-column
\code{permissions_resource} containing lists of
\href{https://developers.google.com/drive/v3/reference/permissions#resource}{Permissions resources}.
}

\section{Publishing}{

When \code{what = "published"} the \code{\link{dribble}} gains a logical variable
\code{published} that indicates whether a file is published and a new list-column
\code{revision_resource} containing lists of
\href{https://developers.google.com/drive/v3/reference/revisions#resource}{Revisions resources}.
}

\examples{
\dontrun{
## Get a nice, random selection of files
files <- drive_find(n_max = 10, trashed = NA)

## Reveal
##   * paths (warning: can be slow for many files!)
##   * if `trashed` or not
##   * MIME type
##   * permissions, i.e. sharing status
##   * if `published` or not
drive_reveal(files, "path")
drive_reveal(files, "trashed")
drive_reveal(files, "mime_type")
drive_reveal(files, "permissions")
drive_reveal(files, "published")

## 'root' is a special file id that always represents your root folder
drive_get(id = "root") \%>\% drive_reveal("path")
}
}
