% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_download.R
\name{gs_download}
\alias{gs_download}
\title{Download a spreadsheet}
\usage{
gs_download(from, ws = NULL, to = "my_sheet.xlsx", overwrite = FALSE,
  verbose = TRUE)
}
\arguments{
\item{from}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{to}{path to write file; file extension must be one of .csv, .pdf, or
.xlsx, which dictates the export format}

\item{overwrite}{logical, indicating whether to overwrite an existing local
file}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Export a Google Sheet as a .csv, .pdf, or .xlsx file. You can download a
sheet that you own or a sheet owned by a third party that has been made
accessible via the sharing dialog options. You can download the entire
spreadsheet (.pdf and .xlsx formats) or a single worksheet. This function
calls the \href{https://developers.google.com/drive/v2/reference/}{Google
Drive API}. Note that the current implementation of this function absolutely
requires authorization.
}
\details{
If the worksheet is unspecified, i.e. if \code{ws = NULL}, then the entire
spreadsheet will be exported (.pdf and xlsx formats) or the first worksheet
will be exported (.csv format)
}
\examples{
\dontrun{
gs_download(gs_gap(), to = "gapminder.xlsx")
file.remove("gapminder.xlsx")
}
}

