% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_reshape_cellfeed.R
\name{gs_reshape_cellfeed}
\alias{gs_reshape_cellfeed}
\title{Reshape data from the "cell feed"}
\usage{
gs_reshape_cellfeed(x, col_names = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{a data.frame returned by \code{\link{gs_read_cellfeed}}}

\item{col_names}{if \code{TRUE}, the first row of the input will be used as
 the column names; if \code{FALSE}, column names will be X1, X2, etc.; if a
character vector, vector will be used as the column names}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Reshape data from the "cell feed" and convert to a \code{tbl_df}
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
gs_read_cellfeed(gap_ss, "Asia", range = cell_rows(1:4))
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia", range = cell_rows(1:4)))
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia",
                                     range = cell_rows(2:4)),
                    col_names = FALSE)
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia",
                                     range = cell_rows(2:4)),
                    col_names = paste0("yo", 1:6))
}
}
\seealso{
Other data.consumption.functions: \code{\link{gs_read_cellfeed}};
  \code{\link{gs_read_csv}};
  \code{\link{gs_read_listfeed}}; \code{\link{gs_read}};
  \code{\link{gs_simplify_cellfeed}}
}

