% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyline.R
\name{decode_pl}
\alias{decode_pl}
\title{Decode PL}
\usage{
decode_pl(encoded)
}
\arguments{
\item{encoded}{String. An encoded polyline}
}
\value{
data.frame of lat/lon coordinates
}
\description{
Decodes an encoded polyline into the series of lat/lon coordinates that specify the path
}
\note{
An encoded polyline is generated from google's polyline encoding algorithm (\url{https://developers.google.com/maps/documentation/utilities/polylinealgorithm}).
}
\examples{
## polyline joining the capital cities of Australian states
pl <- "nnseFmpzsZgalNytrXetrG}krKsaif@kivIccvzAvvqfClp~uBlymzA~ocQ}_}iCthxo@srst@"

df_polyline <- decode_pl(pl)
df_polyline
}
\seealso{
\link{encode_pl}, \link{google_directions}
}

