% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map.R
\name{google_map-shiny}
\alias{google_map-shiny}
\alias{google_mapOutput}
\alias{renderGoogle_map}
\title{Shiny bindings for google_map}
\usage{
google_mapOutput(outputId, width = "100\%", height = "400px")

renderGoogle_map(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a google_map}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using google_map within Shiny applications and interactive Rmd documents.
}
\examples{
\dontrun{
library(shiny)
library(googleway)

ui <- fluidPage(google_mapOutput("map"))

server <- function(input, output, session){

api_key <- "your_api_key"

  df <- structure(list(lat = c(-37.8201904296875, -37.8197288513184,
  -37.8191299438477, -37.8187675476074, -37.8186187744141, -37.8181076049805
  ), lon = c(144.968612670898, 144.968414306641, 144.968139648438,
  144.967971801758, 144.967864990234, 144.967636108398), weight = c(31.5698964400217,
  97.1629025738221, 58.9051092562731, 76.3215389118996, 37.8982300488278,
  77.1501972114202), opacity = c(0.2, 0.2, 0.2, 0.2, 0.2, 0.2)), .Names = c("lat",
  "lon", "weight", "opacity"), row.names = 379:384, class = "data.frame")

  output$map <- renderGoogle_map({
    google_map(key = api_key)
  })
}

shinyApp(ui, server)
}

}

