% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_directions.R
\name{google_directions}
\alias{google_directions}
\title{Google Directions}
\usage{
google_directions(origin, destination, mode = c("driving", "walking",
  "bicycling", "transit"), departure_time = NULL, arrival_time = NULL,
  waypoints = NULL, optimise_waypoints = FALSE, alternatives = FALSE,
  avoid = NULL, units = c("metric", "imperial"), traffic_model = NULL,
  transit_mode = NULL, transit_routing_preference = NULL, language = NULL,
  region = NULL, key = get_api_key("directions"), simplify = TRUE,
  curl_proxy = NULL)
}
\arguments{
\item{origin}{Origin location as either a one or two column data.frame, a
list of unnamed elements, each element is either a numeric vector of lat/lon
coordinates, an address string or a place_id, or a vector of a pair of lat / lon coordinates}

\item{destination}{destination location as either a one or two column data.frame, a
list of unnamed elements, each element is either a numeric vector of lat/lon
coordinates, an address string or place_id, or a vector of a pair of lat / lon coordinates}

\item{mode}{string. One of 'driving', 'walking', 'bicycling' or 'transit'.}

\item{departure_time}{\code{POSIXct}. Specifies the desired time of departure.
Must be in the future (i.e. greater than \code{sys.time()}). If no value
is specified it defaults to \code{Sys.time()}}

\item{arrival_time}{\code{POSIXct}. Specifies the desired time of arrival. Note you
can only specify one of \code{arrival_time} or \code{departure_time}, not both.
If both are supplied, \code{departure_time} will be used.}

\item{waypoints}{list of waypoints, expressed as either \code{vectors} of
lat/lon coordinates, or a \code{string} address to be geocoded, or an encoded
polyline enclosed by \code{enc:} and \code{:}. Only available for driving,
walking or bicycling modes. List elements must be named either 'stop' or 'via',
where 'stop' is used to indicate a stopover for a waypoint, and 'via' will
not stop at the waypoint.
See \url{https://developers.google.com/maps/documentation/directions/intro#Waypoints} for details}

\item{optimise_waypoints}{\code{boolean} allow the Directions service to optimize the
provided route by rearranging the waypoints in a more efficient order.
(This optimization is an application of the Travelling Salesman Problem.)
Travel time is the primary factor which is optimized, but other factors such
as distance, number of turns and many more may be taken into account when
deciding which route is the most efficient. All waypoints must be stopovers
for the Directions service to optimize their route.}

\item{alternatives}{\code{logical} If set to true, specifies that the Directions
service may provide more than one route alternative in the response}

\item{avoid}{\code{character} vector stating which features should be avoided.
One of 'tolls', 'highways', 'ferries' or 'indoor'}

\item{units}{\code{string} metric or imperial. Note: Only affects the text displayed
within the distance field. The values are always in metric}

\item{traffic_model}{\code{string} - one of 'best_guess', 'pessimistic' or 'optimistic'.
Only valid with a departure time}

\item{transit_mode}{\code{vector} of strings, either 'bus', 'subway', 'train', 'tram' or 'rail'.
Only vaid where \code{mode = 'transit'}. Note that 'rail' is equivalent
to \code{transit_mode=c("train", "tram", "subway")}}

\item{transit_routing_preference}{\code{vector} of strings - one of 'less_walking' and
'fewer_transfers'. specifies preferences for transit routes. Only valid for
transit directions.}

\item{language}{\code{string} - specifies the language in which to return the results.
See the list of supported languages: \url{https://developers.google.com/maps/faq#languagesupport}.
If no langauge is supplied, the service will attempt to use the language of the domain from which the request was sent}

\item{region}{\code{string} - specifies the region code, specified as a ccTLD
("top-level domain"). See region basing for details
\url{https://developers.google.com/maps/documentation/directions/intro#RegionBiasing}}

\item{key}{\code{string} - a valid Google Developers Directions API key}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be coerced into a list.
FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}
}
\value{
Either list or JSON string of the route between origin and destination
}
\description{
The Google Maps Directions API is a service that calculates directions between
locations. You can search for directions for several modes of transportation,
including transit, driving, walking, or cycling.
}
\section{API use and limits}{


The amount of queries you can make to Google's APIs is dependent on both the service
and the API you are using.

Each API has specific quotas and limits. Check Google's API documentation for details.

View your usage at the Google Cloud Console \url{https://console.cloud.google.com/}

Each API can only accept and return one request at a time. If you write a loop
to make multiple API calls you should ensure you don't go over your quota / limits
during the loop.
}

\examples{
\dontrun{

set_key("YOUR_GOOGLE_API_KEY")

## using lat/long coordinates
google_directions(origin = c(-37.8179746, 144.9668636),
          destination = c(-37.81659, 144.9841),
          mode = "walking")


## using address string
google_directions(origin = "Flinders Street Station, Melbourne",
         destination = "MCG, Melbourne",
         mode = "walking")


google_directions(origin = "Melbourne Airport, Australia",
         destination = "Portsea, Melbourne, Australia",
         departure_time =  Sys.time() + (24 * 60 * 60),
         waypoints = list(stop = c(-37.81659, 144.9841),
                           via = "Ringwood, Victoria"),
         mode = "driving",
         alternatives = FALSE,
         avoid = c("TOLLS", "highways"),
         units = "imperial",
         simplify = TRUE)

## waypoints expressed as an encoded polyline
polyWaypoints <- encode_pl(tram_stops[1:2, c("stop_lat")], tram_stops[1:2, c("stop_lon")])
polyWaypoints <- list(via = paste0("enc:", polyWaypoints, ":"))

google_directions(origin = "Melbourne Zoo, Melbourne",
         destination = "Studley Park, Melbourne",
         waypoints = polyWaypoints)


## using bus and less walking
google_directions(origin = "Melbourne Airport, Australia",
         destination = "Portsea, Melbourne, Australia",
         departure_time =  Sys.time() + (24 * 60 * 60),
         mode = "transit",
         transit_mode = "bus",
         transit_routing_preference = "less_walking",
         simplify = FALSE)

## using arrival time
google_directions(origin = "Melbourne Airport, Australia",
         destination = "Portsea, Melbourne, Australia",
         arrival_time =  Sys.time() + (24 * 60 * 60),
         mode = "transit",
         transit_mode = "bus",
         transit_routing_preference = "less_walking",
         simplify = FALSE)

## return results in French
google_directions(origin = "Melbourne Airport, Australia",
         destination = "Portsea, Melbourne, Australia",
         arrival_time =  Sys.time() + (24 * 60 * 60),
         mode = "transit",
         transit_mode = "bus",
         transit_routing_preference = "less_walking",
         language = "fr",
         simplify = FALSE)

}
}
