% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_timezone.R
\name{google_timezone}
\alias{google_timezone}
\title{Google timezone}
\usage{
google_timezone(
  location,
  timestamp = Sys.time(),
  language = NULL,
  simplify = TRUE,
  curl_proxy = NULL,
  key = get_api_key("timezone")
)
}
\arguments{
\item{location}{\code{vector} of lat/lon pair}

\item{timestamp}{\code{POSIXct} The Google Maps Time Zone API uses the timestamp to
determine whether or not Daylight Savings should be applied. Will default to
the current system time.}

\item{language}{\code{string} specifies the language in which to return the results.
See the list of supported languages:
\url{https://developers.google.com/maps/faq#using-google-maps-apis}.
If no langauge is supplied, the service will attempt to use the language of
the domain from which the request was sent.}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be
coerced into a list. FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}

\item{key}{\code{string} A valid Google Developers Timezone API key.}
}
\value{
Either list or JSON string of the timezone
}
\description{
The Google Maps Time Zone API provides time offset data for locations on the
surface of the earth. You request the time zone information for a specific
latitude/longitude pair and date.
}
\section{API use and limits}{


The amount of queries you can make to Google's APIs is dependent on both the service
and the API you are using.

Each API has specific quotas and limits. Check Google's API documentation for details.

View your usage at the Google Cloud Console \url{https://console.cloud.google.com/}

Each API can only accept and return one request at a time. If you write a loop
to make multiple API calls you should ensure you don't go over your quota / limits
during the loop.
}

\examples{
\dontrun{
google_timezone(location = c(-37.81659, 144.9841),
               timestamp = as.POSIXct("2016-06-05"),
               key = "<your valid api key>")
}

}
