% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{confint.gower}
\alias{confint.gower}
\title{Compute a credible interval for a Bayesian Gower fit.}
\usage{
\method{confint}{gower}(object, parm = "mu", level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{"gower"}, the result of a call to \code{\link{gower.agree}}.}

\item{parm}{always ignored since there is only one parameter, mu.}

\item{level}{the desired confidence level for the interval. The default is 0.95.}

\item{\dots}{additional arguments. These are passed to \code{\link{quantile}}.}
}
\value{
A vector with entries giving the lower and upper limits of the interval. These will be labelled as (1 - level) / 2 and 1 - (1 - level) / 2 if the quantile method was used. They will be labeled "Lower" and "Upper" if the interval is an HPD interval.
}
\description{
Compute a credible interval for a Bayesian Gower fit.
}
\details{
This function computes a credible interval for mu, the agreement parameter.

This function uses the bootstrap sample to compute a credible interval. If \code{type = "HPD"} is not an element of \dots, the lower and upper limits of the interval are appropriate quantiles of the bootstrap sample. Otherwise the limits are for an HPD interval.
}
\examples{

# Fit the liver data, using the mean distance for each row of the data matrix.
# The range (which is equal to 4) must be passed to \code{\link{gower.agree}}
# since these data are ordinal and the L1 distance function is used. We assume
# a one-way sampling design for these data, i.e., units are random and coders
# are fixed. Also compute a 95\\% credible interval using the quantile method
# and then the HPD method.

data(liver)
liver = as.matrix(liver)
fit = gower.agree(liver, data.type = "ordinal", range = 4)
confint(fit)
confint(fit, type = "HPD")
}
\seealso{
\code{\link{gower.agree}}
}
