% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gower.R
\name{summary.gower}
\alias{summary.gower}
\title{Print a summary of a Bayesian Gower fit.}
\usage{
\method{summary}{gower}(object, conf.level = 0.95, digits = 4, ...)
}
\arguments{
\item{object}{an object of class \code{"gower"}, the result of a call to \code{\link{gower.agree}}.}

\item{conf.level}{the confidence level for the credible interval. The default is 0.95.}

\item{digits}{the number of significant digits to display. The default is 4.}

\item{\dots}{additional arguments. These are currently ignored.}
}
\value{
A list containing various elements of the summary is returned invisibly, but this function should be called for its side effects.
}
\description{
Print a summary of a Bayesian Gower fit.
}
\details{
This function prints a summary of the fit.
}
\examples{

# Fit the liver data, using the mean distance for each row of the data matrix.
# The range (which is equal to 4) must be passed to \code{\link{gower.agree}}
# since these data are ordinal and the L1 distance function is used. We assume
# a one-way sampling design for these data, i.e., units are random and coders
# are fixed.

data(liver)
liver = as.matrix(liver)
fit = gower.agree(liver, data.type = "ordinal", range = 4)
summary(fit)
}
\seealso{
\code{\link{gower.agree}}
}
