% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfo.R
\name{tfo}
\alias{tfo}
\title{Predicting triplex forming oligonucleotide(s)}
\usage{
tfo(x, xformat = "default")
}
\arguments{
\item{x}{DNA sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which triplex forming oligonucleotide(s) will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank (GenBank accession number(s)).}
}
\value{
A dataframe of triplex forming oligonucleotide(s) position, sequence and length. If more than one DNA sequence is provided as argument, an input ID is returned for motif(s) predicted from each input sequence.
}
\description{
This function predicts triplex forming oligonucleotide(s)
in 'x' in DNA. DNA sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts triplex forming oligonucleotide(s) in DNA sequences and provide the position, sequence and length of the predicted motif(s), if any.
}
\examples{
 ## Predicting triplex forming oligonucleotide(s) from raw DNA sequences
E1 <- c("TCTTGGGAGGGAGAGAGAGAAAGAGATCTGGAGGCCGGAAT", "taggtgctgggaggtagagacaggatatcct")
tfo(E1)

## Predicting triplex forming oligonucleotide(s) from DNA sequences in fasta file
## Not run: tfo(x="Example.fasta", xformat = "fasta")

## Predicting triplex forming oligonucleotide(s) from DNA sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: tfo(c("BH114913", "AY611035"), xformat = "GenBank")
}
\references{
paper under review
}
\author{
Hannah O. Ajoge
}
