% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{mean}
\alias{mean}
\alias{mean.winmove}
\title{Arithmetic mean}
\usage{
mean(x, ...)

\method{mean}{winmove}(x, d, type, ...)
}
\arguments{
\item{x}{RasterLayer. The data over which to calculate the mean value within a moving
window}

\item{...}{further arguments passed to or from other methods}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the
CRS). If \code{type=rectangle} the dimension of the rectangle (one or two numbers)}

\item{type}{character. The shape of the moving window}
}
\value{
RasterLayer. A smoothed raster with the mean calculated within the specified
  moving window
}
\description{
An extension to \code{mean} for objects of class \code{winmove}
}
\examples{

# load required data
data(cont_ls)

# convert data to object of class winmove
cont_ls <- new("winmove", cont_ls)

# aggregate using a circular window with radius 3
d <- mean(cont_ls, d = 3, type = "circle")
}
\keyword{focal}
\keyword{mean}
\keyword{spatial}
