% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grainscape-deprecated.R
\name{gsGOC}
\alias{gsGOC}
\alias{gsGOCCorridor}
\alias{gsGOCDistance}
\alias{gsGOCPoint}
\alias{gsGOCVisualize}
\alias{visualize}
\alias{gsGraphDataFrame}
\alias{gsMPG}
\title{Deprecated functions}
\usage{
gsGOC(
  mpg,
  nThresh = NULL,
  doThresh = NULL,
  weight = "lcpPerimWeight",
  sp = FALSE,
  verbose = 3
)

gsGOCCorridor(GOC, whichThresh, coords, doPlot = FALSE, weight = "meanWeight")

gsGOCDistance(GOC, coords, weight = "meanWeight")

gsGOCPoint(GOC, coords)

gsGOCVisualize(GOC, whichThresh, sp = FALSE, doPlot = FALSE)

visualize(GOC, whichThresh, sp = FALSE, doPlot = FALSE)

gsGraphDataFrame(x)

gsMPG(cost, patch, sa = NULL, filterPatch = NULL, spreadFactor = 0)
}
\arguments{
\item{mpg}{A \code{mpg} object.}

\item{nThresh}{Optional. An integer giving the number of thresholds (or scales)
at which to create GOC models. Thresholds are selected to produce
a maximum number of unique grains (i.e., models).
\code{nThresh} thresholds are also approximately evenly spread
between 0 and the threshold at which all patches or focal points
on the landscape are connected. This is a simple way to get
a representative subset of all possible GOC models.
Provide either \code{nThresh} or \code{doThresh} not both.}

\item{doThresh}{Optional. A vector giving the link thresholds at which to create GOC models.
Use \code{\link[=threshold]{threshold()}} to identify thresholds of interest.
Provide either \code{nThresh} or \code{doThresh} not both.}

\item{weight}{A string giving the link weight or attribute to use for threshold.
\code{"lcpPerimWeight"} uses the accumulated resistance or least-cost
path distance from the perimeters of patches as the link weight.}

\item{sp}{Logical. If \code{TRUE} the \code{sp} package is used to create
a vector of class \code{\link[=SpatialPolygonsDataFrame]{SpatialPolygonsDataFrame()}} describing
the finest grain of connectivity.}

\item{verbose}{Set \code{verbose=0} for no progress information to console.}

\item{GOC}{A \code{goc} object.}

\item{whichThresh}{Integer giving the index of the threshold to visualize.}

\item{coords}{A two column matrix or a \code{\link[=SpatialPoints]{SpatialPoints()}} object
giving coordinates at the end points of the corridor.}

\item{doPlot}{Logical. If \code{TRUE} plots a vector visualization of the
corridor at the given scale}

\item{x}{A \code{mpg} object produced by \code{\link[=MPG]{MPG()}}.
For lattice GOC \code{MPG} must be run with patch set as an integer value.}

\item{cost}{A \code{RasterLayer} giving a landscape resistance surface,
where the values of each raster cell are proportional to the
resistance to movement, dispersal, or gene flow for an organism
in the landscape feature they represent.
Missing values \code{NA} are acceptable (but see below).
Negative values are not.
To extract an MPG with Euclidean links (i.e., and not least-cost
path links) set \code{cost[] <- 1}.}

\item{patch}{A raster of class \code{RasterLayer} for a patch-based analysis
OR an integer for a lattice analysis.
If a raster is given it must be of the same extent, origin and
projection as \code{cost} and be binary, without missing values,
where patches=1 and non-patches=0.
For lattice analyses, an integer gives the spacing in raster
cells between focal points in the lattice.}

\item{filterPatch, sa, spreadFactor}{No longer used.}
}
\description{
These have been deprecated and will be removed in a future release.
}
\note{
the \code{sp} argument has also been deprecated from all functions.
}
