% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_pw_mat.R
\name{df_to_pw_mat}
\alias{df_to_pw_mat}
\title{Convert an edge-list data.frame into a pairwise matrix}
\usage{
df_to_pw_mat(data, from, to, value)
}
\arguments{
\item{data}{An object of class \code{data.frame}}

\item{from}{A character string indicating the name of the column with the ID
of the origins}

\item{to}{A character string indicating the name of the column with the ID
of the arrivals}

\item{value}{A character string indicating the name of the column with the
values corresponding to each pair}
}
\value{
A pairwise matrix
}
\description{
The function converts an edge-list data.frame
into a symmetric pairwise matrix
}
\details{
The matrix is a symmetric matrix. Be careful, you shall not provide
a data.frame with different values corresponding to the pair 1-2 and 2-1 as
an example. Ideally, for a complete matrix, data should have n(n-1)/2 rows
if values are computed between n objects.
}
\examples{
data(pts_pop_simul)
suppressWarnings(mat_geo <- mat_geo_dist(pts_pop_simul,
                 ID = "ID",
                 x = "x",
                y = "y"))
g <- gen_graph_topo(mat_w = mat_geo,
                    mat_topo = mat_geo,
                    topo = "comp")
df <- data.frame(igraph::as_edgelist(g))
df$w <- igraph::E(g)$weight
df_to_pw_mat(df, from = "X1", to = "X2", value = "w")
}
\author{
P. Savary
}
