% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graphab_raster_codes.R
\name{get_graphab_raster_codes}
\alias{get_graphab_raster_codes}
\title{Get unique raster codes from a Graphab project}
\usage{
get_graphab_raster_codes(proj_name, mode = "all", proj_path = NULL)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml will be created.}

\item{mode}{A character string equal to either 'all' (default) or 'habitat'
indicating whether the returned codes are all the codes of the source raster
used for creating the project or only the code corresponding to the
habitat patches.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}
}
\value{
The function returns a vector of integer values corresponding to
the source raster codes (all the codes or only the one corresponding to
habitat patches).
}
\description{
The function extracts unique raster codes from a Graphab project
}
\examples{
\dontrun{
proj_name <- "grphb_ex"
get_graphab_raster_codes(proj_name = proj_name,
               mode = "all")
}
}
\author{
P. Savary
}
