% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_pointset.R
\name{graphab_pointset}
\alias{graphab_pointset}
\title{Add a point set to the Graphab project}
\usage{
graphab_pointset(
  proj_name,
  linkset,
  pointset,
  id = "ID",
  return_val = TRUE,
  proj_path = NULL,
  alloc_ram = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{linkset}{A character string indicating the name of the link set used.
The link set is here used to get the defined cost values and compute the
distance from the point to the patches. Link sets can be created
with \code{\link{graphab_link}}.}

\item{pointset}{Can be either;\itemize{
\item{A character string indicating the path (absolute or relative) to a
shapefile point layer}
\item{A character string indicating the path to a .csv file with three
columns: ID, x and y, respectively indicating the point ID, longitude
and latitude.}
\item{A data.frame with three columns:
ID, x and y, respectively indicating the point ID, longitude and latitude.}
\item{A SpatialPointsDataFrame}
}
The point ID column must be 'ID' by default but can also be specified
by the \code{id} argument in all three cases.}

\item{id}{A character string indicating the name of the column in either
the .csv table, data.frame or attribute table, corresponding to the ID
of the points. By default, it should be 'ID'. This column is used for naming
the points when returning the output.}

\item{return_val}{Logical (default=TRUE) indicating whether the metrics
associated with closest habitat patches from the points are returned to
users.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}
}
\value{
If \code{return_val=TRUE}, the function returns a \code{data.frame}
with the properties of the nearest patch to every point in the point set,
as well as the distance from each point to the nearest patch.
}
\description{
The function adds a spatial point set to the Graphab project,
allowing users to identify closest habitat patch from each point and
get corresponding connectivity metrics.
}
\details{
Point coordinates must be in the same coordinate reference system
as the habitat patches (and initial raster layer). See more information in
Graphab 2.8 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.8-en.pdf}
}
\examples{
\dontrun{
graphab_pointset(proj_name = "grphb_ex",
               graph = "graph",
               pointset = "pts.shp")
}
}
\author{
P. Savary
}
