% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAF_calc_continuous.R
\name{risk_quantiles}
\alias{risk_quantiles}
\title{Return the vector of risk quantiles for a continuous risk factor.}
\usage{
risk_quantiles(
  riskfactor,
  data,
  model,
  S = 1,
  q = seq(from = 0.01, to = 0.99, by = 0.01)
)
}
\arguments{
\item{riskfactor}{The name of the risk factor of interest in the dataset.  A character vector}

\item{data}{A dataframe containing variables used to fit the model}

\item{model}{The fitted model}

\item{S}{The number of randomly selected individuals for which risk is measured (defaults to 1).  Let to perhaps 100 if risk factor involved in interactions in model}

\item{q}{The desired risk quantiles}
}
\value{
A named vector of size S giving the risk factor quantiles
}
\description{
Return the vector of risk quantiles for a continuous risk factor.
}
