% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearmonth.R
\name{as_yearmonth}
\alias{as_yearmonth}
\alias{as_yearmonth.default}
\alias{as_yearmonth.Date}
\alias{as_yearmonth.POSIXt}
\alias{as_yearmonth.character}
\alias{as_yearmonth.factor}
\title{Coerce an object to year-month}
\usage{
as_yearmonth(x, ...)

\method{as_yearmonth}{default}(x, ...)

\method{as_yearmonth}{Date}(x, ...)

\method{as_yearmonth}{POSIXt}(x, ...)

\method{as_yearmonth}{character}(x, ...)

\method{as_yearmonth}{factor}(x, ...)
}
\arguments{
\item{x}{\R object.}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_yearmonth>} object.
}
\description{
\code{as_yearmonth()} is a generic for coercing input in to \verb{<grates_yearmonth>}.
Character input is first parsed using \code{as.Date()}. POSIXct and POSIXlt are
all converted, with the timezone respected.
}
\note{
Internally \verb{<grates_yearmonth>} objects are stored as the number of
months (starting at 0) since the Unix Epoch (1970-01-01). Precision is only
to the month level (i.e. the day of the month is always dropped).
}
\examples{
as_yearmonth(Sys.Date())
as_yearmonth(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), interval = 2)
as_yearmonth("2019-05-03")

}
\references{
The algorithm to convert between dates and months relative to the
UNIX Epoch comes from the work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package.
}
\seealso{
\code{as.Date()}
}
