% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month.R
\name{as_month}
\alias{as_month}
\alias{as_month.default}
\alias{as_month.Date}
\alias{as_month.POSIXt}
\alias{as_month.character}
\alias{as_month.factor}
\title{Coerce an object to month}
\usage{
as_month(x, n, ...)

\method{as_month}{default}(x, n, ...)

\method{as_month}{Date}(x, n, ...)

\method{as_month}{POSIXt}(x, n, ...)

\method{as_month}{character}(x, n, ...)

\method{as_month}{factor}(x, n, ...)
}
\arguments{
\item{x}{An \R object.

Character input is first parsed using \code{as.Date()}.

POSIXt inputs are converted with the timezone respected.}

\item{n}{\verb{[integer]}

Number of months that are being grouped. Must be greater than 1 (use
\code{as_yearmonth()} for this case).}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_month>} object.
}
\description{
\code{as_month()} is a generic for coercing input in to \verb{<grates_month>}.
}
\note{
Internally \code{grates_month} objects are stored as the position, starting at 0,
of n-month groups since the Unix Epoch (1970-01-01). Here n-months is taken
to mean a 'grouping of n consecutive months'. Precision is only to the month
level (i.e. the day of the  month is always dropped).
}
\examples{
as_month("2019-05-03", n = 4L)
as_month(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), n = 2)

}
\references{
The algorithm to convert between dates and months relative to the UNIX Epoch
comes from the work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package.
}
\seealso{
\code{as.Date()}
}
