% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_generator.R
\name{rmm}
\alias{rmm}
\title{Generate data using a Multinomial Mixture}
\usage{
rmm(N, pi, mu, lambda)
}
\arguments{
\item{N}{A numeric value the size of the graph to generate}

\item{pi}{A numeric vector of length K with clusters proportions. Must sum up to 1.}

\item{mu}{A numeric matrix of dim k x D with the clusters patterns to generate, all elements in [0,1].}

\item{lambda}{A numeric value which specify the expectation for the row sums.}
}
\value{
A list with fields:
\itemize{
\item x: the count matrix as a \code{dgCMatrix}
\item K: number of generated clusters
\item N: number of vertex
\item cl: vector of clusters labels
\item pi: clusters proportions
\item mu: connectivity matrix
\item lambda: expectation of row sums
}
}
\description{
\code{rmm} returns a count matrix and the cluster labels generated randomly with a Mixture of Multinomial model.
}
\details{
It takes the sample size, cluster proportions and emission matrix, and  as input and sample a graph accordingly together with the clusters labels.
}
