% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_generator.R
\name{rmultsbm}
\alias{rmultsbm}
\title{Generate a graph adjacency matrix using a Stochastic Block Model}
\usage{
rmultsbm(N, pi, mu, lambda)
}
\arguments{
\item{N}{The size of the graph to generate}

\item{pi}{A numeric vector of length K with clusters proportions (will be normalized to sum up to 1).}

\item{mu}{A numeric array of dim K x K x M with the connectivity pattern to generate. elements in [0,1].}

\item{lambda}{A double with the Poisson intensity to generate the total counts}
}
\value{
A list with fields:
\itemize{
\item x: the multi-graph adjacency matrix as an \code{array}
\item K: number of generated clusters
\item N: number of vertex
\item cl: vector of clusters labels
\item pi: clusters proportions
\item mu: connectivity matrix
\item lambda:
}
}
\description{
\code{rmultsbm} returns the multi-graph adjacency matrix and the cluster labels generated randomly with a Multinomial Stochastic Block Model.
}
\details{
This function takes the desired graph size, cluster proportions and connectivity matrix as input and sample a graph accordingly together with the clusters labels.
}
\examples{
simu <- rsbm(100, rep(1 / 5, 5), diag(rep(0.1, 5)) + 0.001)
}
