% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmcb.R
\name{rmcb}
\alias{rmcb}
\alias{plot.rmcb}
\title{Regression for Multiple Comparison with the Best}
\usage{
rmcb(data, level = 0.95, outplot = c("mcb", "lines", "none"),
  select = NULL, ...)

\method{plot}{rmcb}(x, outplot = c("mcb", "lines"), select = NULL, ...)
}
\arguments{
\item{data}{Matrix or data frame with observations in rows and variables in
columns.}

\item{level}{The width of the confidence interval. Default is 0.95.}

\item{outplot}{What type of plot to use after the calculations. This can be
either "MCB" (\code{"mcb"}), or "Vertical lines" (\code{"lines"}), or nothing
(\code{"none"}). You can also use plot method on the produced object in order
to get the same effect.}

\item{select}{What column of data to highlight on the plot. If NULL, then
the method with the lowest value is selected.}

\item{...}{Other parameters passed to \link[base]{rank} function.}

\item{x}{The produced rmcb model.}
}
\value{
If \code{outplot!="none"}, then the function plots the results after all
the calculations using plot.rmcb() function.

Function returns a list of a class "rmcb", which contains the following
variables:
\itemize{
\item{mean}{Mean values for each method.}
\item{interval}{Confidence intervals for each method.}
\item{vlines}{Coordinates used for outplot="l", marking the groups of methods.}
\item{groups}{The table containing the groups. \code{TRUE} - methods are in the
same group, \code{FALSE} - they are not.}
\item{methods}{Similar to \code{group} parameter, but with a slightly different
presentation.}
\item{p.value}{p-value for the test of the significance of the model. This is the
value from the F test of the linear regression.}
\item{level}{Confidence level.}
\item{model}{lm model produced for the calculation of the intervals.}
\item{outplot}{Style of the plot to produce.}
\item{select}{The selected variable to highlight.}
}
}
\description{
RMCB stands for "Regression for Multiple Comparison with the Best", referring to the
comparison of forecasting methods. This is a regression-based version of the
Nemenyi / MCB test relies on the ranks of variables.
This test is based on Nemenyi / MCB test (Demsar, 2006). It transforms the data into
ranks and then constructs a regression on them of the type:
}
\details{
y = b' X + e,

where y is the vector of the ranks of provided data (as.vector(data)), X is the matrix
of dummy variables for each column of the data (forecasting method), b is the
vector of coefficients for the dummies and e is the error term of the model. Given
that the data is ranked, it test the differences in medians between the methods and
then produces plots based on that.

There is also a \code{plot()} method that allows producing either "mcb" or "lines"
style of plot. This can be regulated via \code{plot(x, outplot="lines")}.
}
\examples{
N <- 50
M <- 4
ourData <- matrix(rnorm(N*M,mean=0,sd=1), N, M)
ourData[,2] <- ourData[,2]+4
ourData[,3] <- ourData[,3]+3
ourData[,4] <- ourData[,4]+2
colnames(ourData) <- c("Method A","Method B","Method C - long name","Method D")
ourTest <- rmcb(ourData, level=0.95)

# See the mean ranks:
ourTest$mean
# The same is for the intervals:
ourTest$interval

# You can also reproduce plots in different styles:
plot(ourTest, outplot="lines")

# Or you can use the default "mcb" style and set additional parameters for the plot():
par(mar=c(2,2,4,0)+0.1)
plot(ourTest, main="Four methods")

}
\references{
\itemize{
\item  Demsar, J. (2006). Statistical Comparisons of Classifiers over
Multiple Data Sets. Journal of Machine Learning Research, 7, 1-30.
\url{http://www.jmlr.org/papers/volume7/demsar06a/demsar06a.pdf}
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
