% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrumental_forest.R
\name{instrumental_forest}
\alias{instrumental_forest}
\title{Intrumental forest}
\usage{
instrumental_forest(X, Y, W, Z, sample.fraction = 0.5, mtry = NULL,
  num.trees = 2000, num.threads = NULL, min.node.size = NULL,
  honesty = TRUE, ci.group.size = 2, precompute.nuisance = TRUE,
  split.regularization = 0, alpha = 0.05, lambda = 0,
  downweight.penalty = FALSE, seed = NULL)
}
\arguments{
\item{X}{The covariates used in the instrumental regression.}

\item{Y}{The outcome.}

\item{W}{The treatment assignment (may be binary or real).}

\item{Z}{The instrument (may be binary or real).}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used.}

\item{ci.group.size}{The forst will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2.}

\item{precompute.nuisance}{Should we first run regression forests to estimate
y(x) = E[Y|X=x], w(x) = E[W|X=x] and z(x) = E[Z|X=x],
and then run an instrumental forest on the residuals?
This approach is recommended, computational resources
permitting.}

\item{split.regularization}{Whether splits should be regularized towards a naive
splitting criterion that ignores the instrument (and
instead emulates a causal forest).}

\item{alpha}{Maximum imbalance of a split.}

\item{lambda}{A tuning parameter to control the amount of split regularization (experimental).}

\item{downweight.penalty}{Whether or not the regularization penalty should be downweighted (experimental).}

\item{seed}{The seed for the C++ random number generator.}
}
\value{
A trained instrumental forest object.
}
\description{
Trains an instrumental forest that can be used to estimate
conditional local average treatment effects tau(X) identified
using instruments. Formally, the forest estimates
tau(X) = Cov[Y, Z | X = x] / Cov[W, Z | X = x].
Note that when the instrument Z and treatment assignment W
coincide, an instrumental forest is equivalent to a causal forest.
}
