#' 'Groq': Finish code
#'
#' @param code The code to be completed by 'Groq'. If not provided,
#' it will use what's copied on the clipboard.
#' @param ... Following arguments can be set manually or in .Renviron:
#'            `GROQ_API_KEY`is the 'Groq API' key.
#'            `model` Model choice. Default is mistral-7b-instruct.
#'            `systemRole` System role; Default is: "You are a helpful assistant
#'            with extensive knowledge of R programming."
#'            `maxTokens` The maximum integer of completion tokens returned.
#'            `temperature` The amount of randomness in the response,
#'            valued between 0 inclusive and 2 exclusive. Higher values are more
#'            random, and lower values are more deterministic.
#'            `top_p` Nucleus sampling threshold, valued between 0 and 1.
#'            `proxy` Default value is NULL.
#'
#'
#' @examples
#' \dontrun{
#' cat(coder("# A function to square a vector\nsquare_each <- function("))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by 'Groq'.
#'
#' @export
#'
coder <- function(code = NULL, ...) {
  if (is.null(code)) code <- clipr::read_clip(allow_non_interactive = TRUE)
  # Replace all double strings with single string
  code <- gsub('"', "'", code)
  # Collapse the modified 'code' into a character vector
  code <- paste(code, collapse = "\n")
  # Create a prompt string by concatenating the input code
  prompt <- paste0('Complete the following R code: "', code, '"')

  return(APIcall(prompt, ...))
}
