% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aad_set_generics.R, R/multisplit.R
\docType{methods}
\name{multisplit}
\alias{multisplit}
\alias{multisplit,ANY,ANY-method}
\alias{multisplit,data.frame,character-method}
\alias{multisplit,data.frame,factor-method}
\alias{multisplit,data.frame,formula-method}
\alias{multisplit,data.frame,list-method}
\title{Split Data Frame into Multiple Groups}
\usage{
multisplit(data, grouping, drop = TRUE, sep = ":", ...)

\S4method{multisplit}{data.frame,formula}(data, grouping, drop = TRUE,
  sep = ":", ...)

\S4method{multisplit}{data.frame,character}(data, grouping, drop = TRUE,
  sep = ":", ...)

\S4method{multisplit}{data.frame,factor}(data, grouping, drop = TRUE,
  sep = ":", ...)

\S4method{multisplit}{data.frame,list}(data, grouping, drop = TRUE,
  sep = ":", ...)

\S4method{multisplit}{ANY,ANY}(data, grouping, drop = TRUE, sep = ":", ...)
}
\arguments{
\item{data}{data frame, matrix or vector containing several subsets of data}

\item{grouping}{either a character vector containing the names of the grouping variables
or a model formula specifying dependent,
independent and grouping variables in the form:
\code{dependent ~ independent | group1 + group2 + ...}.
It may also be a factor or list of factors as in \code{\link{split}}.}

\item{drop}{if drop is TRUE, unused factor levels are dropped from the result.
The default is to drop all factor levels.}

\item{sep}{string to construct the new level labels by joining the
constituent ones.}

\item{\dots}{other parameters passed to \code{\link{split}}, see details.}
}
\value{
list containing data frames of the data subsets as its elements.
  The components of the list are named by their grouping levels.
}
\description{
A data frame is split into a list of data subsets defined by multiple groups.
}
\details{
This function is wrapper around \code{\link{split}} with
  different defaults, slightly different behavior, and methods for additional
  argument classes. \code{multisplit} returns always a data frame.
}
\examples{


data(bactgrowth)

## simple method
spl <- multisplit(bactgrowth, c("strain", "conc", "replicate"))

## preferred method
spl <- multisplit(bactgrowth, value ~ time | strain + conc + replicate)

## show what is in one data set
spl[[1]]
summary(spl[[1]])

## use factor combination
spl[["D:0:1"]]
summary(spl[["D:0:1"]])


lapply(spl, FUN=function(x)
 plot(x$time, x$value,
      main=paste(x[1, "strain"], x[1, "conc"], x[1, "replicate"], sep=":")))


}
\seealso{
\code{\link{split}}
}
\keyword{internal}

