% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{sigma}
\alias{sigma}
\alias{sigma.grpSLOPE}
\title{Extract (estimated) noise level}
\usage{
\method{sigma}{grpSLOPE}(object, ...)
}
\arguments{
\item{object}{A \code{grpSLOPE} object}

\item{...}{Potentially further arguments passed to and from methods}
}
\description{
Extract the noise level of the \code{grpSLOPE} model.
}
\details{
This basically obtains \code{object$sigma}. For \code{R (>= 3.3.0)}
\code{sigma} is an S3 method with the default method coming from the
\code{stats} package.
}
\examples{
set.seed(1)
A   <- matrix(rnorm(100^2), 100, 100)
grp <- rep(rep(1:20), each = 5)
b   <- c(rep(1, 20), rep(0, 80))
y   <- A \%*\% b + rnorm(10) 
# model with unknown noise level
result <- grpSLOPE(X = A, y = y, group = grp, fdr = 0.1)
sigma(result)
# [1] 0.6505558
# model with known noise level
result <- grpSLOPE(X = A, y = y, group = grp, fdr = 0.1, sigma = 1)
sigma(result)
# [1] 1

}

