% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpslope.R
\name{lambdaGroupSLOPE}
\alias{lambdaGroupSLOPE}
\title{Regularizing sequence for Group SLOPE}
\usage{
lambdaGroupSLOPE(method, fdr, group, wt, n.obs = NULL)
}
\arguments{
\item{method}{Possible values are "max", "mean",
and "corrected". See under Details.}

\item{fdr}{Target group false discovery rate (gFDR)}

\item{group}{A vector describing the grouping structure. It should 
contain a group id for each predictor variable.}

\item{wt}{A named vector of weights, one weight per group of predictors
(named according to names as in vector \code{group})}

\item{n.obs}{Number of observations (i.e., number of rows in \code{A});
required only if method is "corrected"}
}
\value{
A vector containing the calculated lambda values.
}
\description{
Generate the regularizing sequence \code{lambda} for the Group SLOPE
problem according to one of multiple methods (see Details).
}
\details{
Multiple methods are available to generate the regularizing sequence \code{lambda}:
\itemize{
  \item "max" -- lambdas as in Theorem 2.5 in Brzyski et. al. (2016).
    Provalby controls gFDR in orthogonal designs.
  \item "mean" -- lambdas of equation (2.16) in Brzyski et. al. (2016).
    Applicable for gFDR control in orthogonal designs. Less conservative than "max".
  \item "corrected" -- lambdas of Procedure 1 in Brzyski et. al. (2016);
    in the special case that all group sizes are equal and \code{wt} is a constant vector, 
    Procedure 6 of Brzyski et. al. (2016) is applied.
    Applicable for gFDR control when predictors from different groups are stochastically independent.
}
}
\examples{
# specify 6 groups of sizes 2, 3, and 4
group <- c(1, 1, 2, 2, 2, 3, 3, 3, 3,
           4, 4, 5, 5, 5, 6, 6, 6, 6)
# set the weight for each group to the square root of the group's size
wt <- rep(c(sqrt(2), sqrt(3), sqrt(4)), 2)
names(wt) <- 1:6
# compute different lambda sequences
lambda.max <- lambdaGroupSLOPE(method="max", fdr=0.1, group=group, wt=wt) 
lambda.mean <- lambdaGroupSLOPE(method="mean", fdr=0.1, group=group, wt=wt) 
lambda.corrected <- lambdaGroupSLOPE(method="corrected", fdr=0.1,
                                     group=group, wt=wt, n.obs=1000)
rbind(lambda.max, lambda.mean, lambda.corrected)
#                      [,1]     [,2]     [,3]     [,4]     [,5]     [,6]
# lambda.max       2.023449 1.844234 1.730818 1.645615 1.576359 1.517427
# lambda.mean      1.880540 1.723559 1.626517 1.554561 1.496603 1.447609
# lambda.corrected 1.880540 1.729811 1.637290 1.568971 1.514028 1.467551

}
\references{
D. Brzyski, A. Gossmann, W. Su, and M. Bogdan (2016) \emph{Group SLOPE -- adaptive selection of groups of predictors}, \url{https://arxiv.org/abs/1610.04960}

D. Brzyski, A. Gossmann, W. Su, and M. Bogdan (2019) \emph{Group SLOPE -- adaptive selection of groups of predictors}. Journal of the American Statistical Association 114 (525): 419–33.
}
