% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dst.R
\name{dst}
\alias{dst}
\title{Discrete Sine Transform}
\usage{
dst(x, n = NROW(x))
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}
}
\value{
Discrete sine transform, returned as a vector or matrix.
}
\description{
Compute the discrete sine transform of a signal.
}
\details{
The discrete sine transform (DST) is closely related to the discrete Fourier
transform. but using a purely real matrix. It is equivalent to the imaginary
parts of a DFT of roughly twice the length.

The DST has four standard variants. This function implements the DCT-I
according to the definition in [1], which is the most common variant, and
the original variant first proposed for image processing.

The 'Matlab' documentation for the DST warns that the use of the function is
not recommended. They do not state the reason why, but it is likely that use
of the discrete cosine transform (DCT)is preferred for image processing.
Because cos(0) is 1, the first coefficient of the DCT (II) is the mean of the
values being transformed. This makes the first coefficient of each 8x8 block
represent the average tone of its constituent pixels, which is obviously a
good start. Subsequent coefficients add increasing levels of detail, starting
with sweeping gradients and continuing into increasingly fiddly patterns, and
it just so happens that the first few coefficients capture most of the signal
in photographic images. Sin(0) is 0, so the DSTs start with an offset of 0.5
or 1, and the first coefficient is a gentle mound rather than a flat plain.
That is unlikely to suit ordinary images, and the result is that DSTs require
more coefficients than DCTs to encode most blocks. This explanation was
provided by Douglas Bagnall on Stackoverflow.
}
\examples{
x <- as.matrix(seq_len(100) + 50 * cos(seq_len(100) * 2 * pi / 40))
ct <- dct(x)
st <- dst(x)

}
\references{
[1] \url{https://en.wikipedia.org/wiki/Discrete_sine_transform}
}
\seealso{
\code{\link{idst}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
