% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracshift.R
\name{fracshift}
\alias{fracshift}
\title{Fractional shift}
\usage{
fracshift(x, d, h = NULL)
}
\arguments{
\item{x}{input data, specified as a numeric vector.}

\item{d}{number of samples to shift \code{x} by, specified as a numeric value}

\item{h}{interpolator impulse response, specified as a numeric vector. If
NULL (default), the interpolator is designed by a Kaiser-windowed sinecard.}
}
\value{
A list of matrices size \code{nr}, where \code{nr} is the number of
  rows in \code{x}. Each element of the list contains a matrix with two rows.
  The first row is the initial index of a sequence of 1’s and the second row
  is the end index of that sequence. If \code{nr == 1} the output is a matrix
  with two rows.
}
\description{
Shift a signal by a (possibly fractional) number of samples.
}
\details{
The function calculates the initial index and end index of the sequences of
1’s in the rows of \code{x}. The clusters are sought in the rows of the array
\code{x}. The function works by finding the indexes of jumps between
consecutive values in the rows of \code{x}.
}
\examples{
N = 1024
t <- seq(0, 1, length.out = N)
x <- exp(-t^2 / 2 / 0.25^2) * sin(2 * pi * 10 * t)
dt <- 0.25
d  <- dt / (t[2] - t[1])
y <- fracshift(x, d)
plot(t, x, type = "l", xlab = "Time", ylab = "Sigfnal")
lines (t, y, col = "red")
legend("topright", legend = c("original", "shifted"), lty = 1, col = 1:2)

}
\references{
[1] A. V. Oppenheim, R. W. Schafer and J. R. Buck,
Discrete-time signal processing, Signal processing series,
Prentice-Hall, 1999.\cr
[2] T.I. Laakso, V. Valimaki, M. Karjalainen and U.K. Laine
Splitting the unit delay, IEEE Signal Processing Magazine,
vol. 13, no. 1, pp 30--59 Jan 1996.
}
\author{
Eric Chassande-Mottin, \email{ecm@apc.univ-paris7.fr},\cr
 Juan Pablo Carbajal, \email{carbajal@ifi.uzh.ch},\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
