% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sos2tf.R
\name{sos2tf}
\alias{sos2tf}
\title{Sos to transfer function}
\usage{
sos2tf(sos, g = 1)
}
\arguments{
\item{sos}{Second-order section representation, specified as an nrow-by-6
matrix, whose rows contain the numerator and denominator coefficients of
the second-order sections:\cr \code{sos <- rbind(cbind(B1, A1), cbind(...),
cbind(Bn, An))}, where \code{B1 <- c(b0, b1, b2)}, and \code{A1 <- c(a0,
a1, a2)} for section 1, etc. The b0 entry must be nonzero for each section.}

\item{g}{Overall gain factor that effectively scales the output \code{b}
vector (or any one of the input \code{Bi} vectors). Default: 1.}
}
\value{
An object of class "Arma" with the following list elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Convert digital filter second-order section data to transfer function form.
}
\examples{
sos <- rbind(c(1, 1, 1, 1, 0, -1), c(-2, 3, 1, 1, 10, 1))
ba <- sos2tf(sos)

}
\seealso{
\code{\link{as.Arma}}, \code{\link{filter}}
}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}.
}
