% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_F.R
\name{cp_F}
\alias{cp_F}
\title{Compute F statistic}
\usage{
cp_F(y, y_hat_restricted, y_hat_full, n = length(y), p_restricted = 0, p_full)
}
\arguments{
\item{y}{numeric vector storing the observed values on the dependent variable}

\item{y_hat_restricted}{numeric vector storing the predicted values on \code{y} based on the restricted model}

\item{y_hat_full}{numeric vector storing the predicted values on \code{y} based on the full model}

\item{n}{numeric vector of length 1 storing the sample size used to train the models}

\item{p_restricted}{numeric vector of length 1 storing the number of predictors involved in training the restricted model}

\item{p_full}{numeric vector of length 1 storing the number of predictors involved in training the full model}
}
\value{
numeric vector of length 1 storing the F-statistic
}
\description{
Computes the F statistic comparing two nested models.
}
\details{
Note that:
\itemize{
\item The full model is always the model with more estimated parameters, the model with more predictor variables.
\item The restricted model is the model with fewer estimated parameters.
\item The restricted model must be nested within the full model.
}
}
\examples{
# Null vs full model
lm_n <- lm(mpg ~ 1, data = mtcars) # Fit a null model
lm_f <- lm(mpg ~ cyl + disp, data = mtcars) # Fit a full model
f_M <- cp_F(
    y = mtcars$mpg,
    y_hat_restricted = predict(lm_n),
    y_hat_full = predict(lm_f),
    p_full = 2
)

# Simpler vs more complex model
lm_f_2 <- lm(mpg ~ cyl + disp + hp + drat + qsec, data = mtcars) # a more complex full model
f_change_M <- cp_F(
    y = mtcars$mpg,
    y_hat_restricted = predict(lm_f),
    y_hat_full = predict(lm_f_2),
    p_restricted = 2,
    p_full = 5
)

}
\author{
Edoardo Costantini, 2023
}
